<?php
/**
 * Plugin Name: Profile Builder - Yes or No Conditional Shortcode
 * Plugin URI: https://www.cozmoslabs.com/
 * Description: A shortcode for Profile Builder which checks if the custom field contains the value yes.
 * Version: 1.0
 * Author: Cozmoslabs
 * Author URI: https://www.cozmoslabs.com/
 * License: CPL
 */

/*  Copyright YEAR  PLUGIN_AUTHOR_NAME  (email : PLUGIN AUTHOR EMAIL)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// Start writing code after this line!
/*
 * Yes No shortcode. Tags: contitional, shortcode, yes, no
 * Use like so: [yes_no_display field="{custom_field_3}"]This is displayed only if field = Yes.[/yes_no_display]
 */
add_shortcode( 'multiple_empty_user_fields', 'wppb_multiple_fields_empty' );
function wppb_multiple_fields_empty( $atts, $content ) {
   extract(
      shortcode_atts( array( 'fields' => '' ), $atts )
   );
   $fields = explode( ',', $atts['fields'] );
 
   foreach ( $fields as $value ) {
      $value = trim( $value );
      if ( ! empty( $value ) ) {
         return $content;
      }
   }
   return '';
}
