<?php
/**
 * Plugin Name: Taxonomy Archive Shortcode
 * Plugin URI: https://www.cozmoslabs.com
 * Description: A simple shortcode to list a taxonomy archive and the posts for each term ex: [list_taxonomy_archive cpt="book" tax="genre"]
 * Version: 1.0
 * Author: Cristian Antohe
 * Author URI: https://www.cozmoslabs.com
 * License: GPL2
 */
 
/*  Copyright 2016 Cristian Antohe
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// Start writing code after this line!

/*
 * Create a shortcode that lists all cpt's ordered by taxonomy term
 */
 
 add_shortcode('list_taxonomy_archive', 'wckc_list_taxonomy_archive');
 function wckc_list_taxonomy_archive($atts){
     $a = shortcode_atts( array(
         'cpt' => 'post',
         'tax' => 'category',
     ), $atts );
  
     $output = '';
  
     $terms = get_terms( array('taxonomy' => $a['tax'], 'hide_empty' => false) );
  
     if( $terms ){
         $output .= '<div class="list_tax_archive">';
         foreach ($terms as $term) {
             if ( is_array($term) && isset($term['invalid_taxonomy']) )
                 return;
  
             $args = array (
                 'post_type'         => $a['cpt'],
                 $a['tax']           => $term->slug,
                 'posts_per_page'    => '-1',
             );
  
             // The Query
             $posts = get_posts($args);
  
             if( empty($posts)){
                 return;
             }
             $output .= "<h4> {$term->name} </h4>";
             $output .= '<ul class="term_archive">';
             foreach($posts as $post){
                 $output .= '<li><a href="'.get_permalink( $post ).'">'.get_the_title( $post ).'</a></li>';
             }
             $output .= '</ul>';
  
         }
         $output .= '</div>';
     }
     return $output;
  
 }