<?php
/**
* Plugin Name: Paid Member Subscriptions - Require First and Last Name fields
* Plugin URI: https://cozmoslabs.com
* Description: Necessary for the payment to work if your Stripe account country is India.
* Version: 1.0
* Author: Georgian Cocora
* Author URI: https://www.cozmoslabs.com/
* License: GPL
*/

/*  Copyright 2020  Georgian Cocora  (email : hello@cozmoslabs.com)
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2, as
   published by the Free Software Foundation.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

add_filter( 'pms_register_form_label_first_name', 'pmsc_first_name_field_label');
function pmsc_first_name_field_label( $attributes ){
	return __( 'First Name *', 'paid-member-subscriptions' );
}

add_filter( 'pms_register_form_label_last_name', 'pmsc_last_name_field_label');
function pmsc_last_name_field_label( $attributes ){
	return __( 'Last Name *', 'paid-member-subscriptions' );
}

add_action( 'pms_register_form_validation', 'pmsc_first_last_validation' );
function pmsc_first_last_validation(){
	if( empty( $_POST['first_name'] ) )
		pms_errors()->add( 'first_name', __( 'This field is required.', 'paid-member-subscriptions' ) );

	if( empty( $_POST['last_name'] ) )
		pms_errors()->add( 'last_name', __( 'This field is required.', 'paid-member-subscriptions' ) );
}
