<?php
/**
 * Plugin Name: Profile Builder - List Unapproved Users shortcode
 * Plugin URI: https://www.cozmoslabs.com/
 * Description: A shortcode for Profile Builder which lists all unapproved users.
 * Version: 1.0
 * Author: Cozmoslabs
 * Author URI: https://www.cozmoslabs.com/
 * License: CPL
 */

/*  Copyright YEAR  PLUGIN_AUTHOR_NAME  (email : PLUGIN AUTHOR EMAIL)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// Start writing code after this line!
/*
 * List unapproved users shortcode.
 * Usage: [unapproved_users]
 */

add_shortcode( 'unapproved_users', 'wppbc_unapproved_users' );
function wppbc_unapproved_users( $atts, $content ){
	$term_id = get_term_by( 'slug', 'unapproved', 'user_status');
	$term_tax = 'user_status';
	$users = get_objects_in_term( $term_id->term_id, $term_tax );

	if ( !empty( $users ) ) {
		$list = '<ul class="user-entry">';
		foreach ( $users as $user_id ) {
			$user = get_user_by('id', $user_id);
			if ( $user ) {
				$list .= '<li>';
				$list .= get_avatar( get_the_author_meta( 'email', $user_id ), '30' );
				$list .= '<strong style="margin-left: 20px;">'. get_the_author_meta('display_name', $user_id) . '</strong>';
			}
		}
		$list .= '</ul>';
	}
	return $list;
}
