<?php
/**
 * Plugin Name: Profile Builder - Yes or No Conditional Shortcode
 * Plugin URI: https://www.cozmoslabs.com/
 * Description: A shortcode for Profile Builder which checks if the custom field contains the value yes.
 * Version: 1.0
 * Author: Cozmoslabs
 * Author URI: https://www.cozmoslabs.com/
 * License: CPL
 */

/*  Copyright YEAR  PLUGIN_AUTHOR_NAME  (email : PLUGIN AUTHOR EMAIL)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// Start writing code after this line!
/*
 * Yes No shortcode. Tags: contitional, shortcode, yes, no
 * Use like so: [yes_no_display field="{custom_field_3}"]This is displayed only if field = Yes.[/yes_no_display]
 */
add_shortcode( 'yes_no_display', 'wppbc_is_field_yes_or_no' );
function wppbc_is_field_yes_or_no( $atts, $content ) {
   extract(
      shortcode_atts( array( 'field' => '' ), $atts )
   );
 
    $user_id = get_current_user_id();
    $meta_key = trim( $atts['field'],"{}");
    $field = get_user_meta( $user_id, $meta_key, true );
 
   if ( $field == 'Yes' || $field == 'yes' ) {
      return $content;
   }
 
   return;
}
