<?php
/**
 * Plugin Name: Profile Builder - Check If Multiple Fields Are Empty
 * Plugin URI: https://www.cozmoslabs.com/
 * Description: A plugin which generates a shortcode which helps you check if multiple fields (from Profile Builer) are empty.
 * Version: 1.0
 * Author: Name Of The Plugin Author
 * Author URI: https://www.cozmoslabs.com/
 * License: CPL
 */

/*  Copyright YEAR  PLUGIN_AUTHOR_NAME  (email : PLUGIN AUTHOR EMAIL)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// Start writing code after this line!
/*
 * Check if multiple fields are empty shortcode. Tags: shortcode, multiple, empty
 * Usage:
 * [multiple_empty_user_fields fields="{{meta_first_name}},{{meta_last_name}}"]
 * Show only if at least one meta is not empty.
 * [/multiple_empty_user_fields]
 */
add_shortcode( 'multiple_empty_user_fields', 'wppb_multiple_fields_empty' );
function wppb_multiple_fields_empty( $atts, $content ) {
   extract(
      shortcode_atts( array( 'fields' => '' ), $atts )
   );
   $fields = explode( ',', $atts['fields'] );

   foreach ( $fields as $value ) {
      $value = trim( $value );
      if ( ! empty( $value ) ) {
         return $content;
      }
   }
   return '';
}
