<?php
/**
 * Plugin Name: Profile Builder - User meta shortcode.
 * Plugin URI: https://www.cozmoslabs.com/
 * Description: This add-ons adds a shortcode that allows you to display meta fields that a specific/current user has. Usage: [user_meta key=”avatar”]
 * Version: 1.0.0
 * Author: Cozmoslabs, Georgian Cocora
 * Author URI: https://www.cozmoslabs.com/
 * Text Domain: paid-member-subscriptions
 * License: GPL2
 *
 * == Copyright ==
 * Copyright 2018 Cozmoslabs (www.cozmoslabs.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

 add_shortcode('user_meta', 'wppbc_toolbox_usermeta_handler');
 function wppbc_toolbox_usermeta_handler( $atts, $content=null){
 
     $user_id = '';
 
     if( isset( $atts['user_id'] ) ){
 
         if( ( !is_multisite() && current_user_can( 'edit_users' ) ) || ( is_multisite() && ( current_user_can( 'remove_users' ) || current_user_can( 'manage_options' ) ) ) )
             $user_id = $atts['user_id'];
         
     }
 
     if( empty( $user_id ) ){
         $user    = wp_get_current_user();
         $user_id = $user->ID;
     }
 
     if ( !isset( $atts['size'] ) ){
         $atts['size'] = '50';
     }
     if ( !isset( $atts['pre'] ) ) {
         $atts['pre'] = '';
     }
     if ( !isset( $atts['post'] ) ) {
         $atts['post'] = '';
     }
     if ( !isset( $atts['wpautop'] ) ) {
         $atts['wpautop'] = '';
     }
 
     if( in_array( $atts['key'], array( 'user_pass', 'user_activation_key' ) ) )
         return;
 
     $user = new WP_User( $user_id );
 
     if ( !$user->exists() ) return;
 
     if ( !array_key_exists( 'key', $atts ) ) return;
 
     if( $atts['key'] == 'avatar' ){
         return $atts['pre'] . get_avatar( $user->ID, $atts['size']) . $atts['post'] ;
     }
 
     if( $atts['key'] === 'id' ){
         $atts['key'] = 'ID';
     }
 
     if ( $user->has_prop( $atts['key'] ) ){
 
         if ($atts['wpautop'] == 'on'){
             $value = wpautop( $user->get( $atts['key'] ) );
         } else {
             $value = $user->get( $atts['key'] );
         }
 
     }
 
     if (!empty( $value )){
         return $atts['pre'] . $value . $atts['post'] ;
     }
 
     if( $atts['key'] === 'role' ){
         $roles = !empty( $user->roles ) ? $user->roles : array();
 
         if( !empty( $roles ) ){
             $value_roles = implode( ', ', $roles );
             return  $atts['pre'] . $value_roles . $atts['post'];
         }
     }
 
     return;
 }