<?php
/**
* Plugin Name: Compare Shortcode
* Plugin URI: http://www.cozmsolabs.com
* Description: Let's you compare two different values based on an operator. Returns what's found inside the shortcode if the compare returned true. Use it like so: [compare val1="test" val2="test" operator="=="] List if the values is the same? [/compare]
* Version: 1.0
* Author: Cozmoslabs
* Author URI: http:/www.cozmoslabs.com
* License: GPL2
*/
/* Copyright Cozmoslabs.com 
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
 
// Start writing code after this line!

/*
 * Compare shortcode. Tags: shortcode, compare,
 * Usage:
	[compare val1="test" val2="test" operator="=="]
		List if the values is the same?
	[/compare]
 */
add_shortcode( 'compare', 'wppbc_compare_shortcode' );
function wppbc_compare_shortcode( $atts, $content ){
	extract(
		$out = shortcode_atts(	array( 'val1' => '', 'val2' => '', 'operator' => ''), $atts )
	);

	foreach($out as $key => $value){
		$out[$key] = str_replace('&#8221;', '', $value );
	}

	$l = $out['val1'];
	$r = $out['val2'];

	if ( version_compare( phpversion(), '5.4.0', '<' ) ) {
		$operators = array(
			'=='    => create_function('$l, $r', 'return $l == $r;'),
			'==='   => create_function('$l, $r', 'return $l === $r;'),
			'!='    => create_function('$l, $r', 'return $l != $r;'),
			'<'     => create_function('$l, $r', 'return $l < $r;'),
			'>'     => create_function('$l, $r', 'return $l > $r;'),
			'<='    => create_function('$l, $r', 'return $l <= $r;'),
			'>='    => create_function('$l, $r', 'return $l >= $r;'),
			''      => create_function('$l, $r', 'return $l == $r;'),
		);
	} else {
		$operators = array(
			'=='    => function($l, $r) {
						return $l == $r;
					},
			'==='   => function($l, $r) {
						return $l === $r;
					},
			'!='    => function($l, $r) {
						return $l != $r;
					},
			'<'     => function($l, $r) {
						return $l < $r;
					},
			'>'     => function($l, $r) {
						return $l > $r;
					},
			'<='    => function($l, $r) {
						return $l <= $r;
					},
			'>='    => function($l, $r) {
						return $l >= $r;
					},
			''      => function($l, $r) {
						return $l == $r;
					},
		);
	}

	if ( !array_key_exists($out['operator'], $operators ) )
		return '<p>The compare operator <strong style="padding:0 10px;">' . $out["operator"] . '</strong> is not recognized. Please try: == , ===, !=, <, >, <=, >=';

	$bool = $operators[$out['operator']]($l, $r);

	if( $bool )
		return $content;
}
