<?php
/*
Plugin Name: WCK - Swift Templates Custom Query Arguments
Plugin URI: http://cozmoslabs.com/
Description: Create Custom Query Arguments in Swift Templates
Author: Cristian Antohe
Version: 0.1
Author URI: http://cozmoslabs.com/
*/

add_action ("init", "wck_stp_custom_args_metabox");
function wck_stp_custom_args_metabox(){
	$fint = array( 
			array( 'type' => 'textarea', 'title' => 'Query Arguments', 'description'=>'Expects a JSON with a structure similar to what <a target="_blank" href="http://codex.wordpress.org/Class_Reference/WP_Query">WP_Query</a> accepts. See available <a target="_blank" href="https://www.cozmoslabs.com/docs/wordpress-creation-kit-documentation/swift-templates/custom-query-arguments/#Json_Custom_Query_Examples">examples</a>' )
		);

	$args = array(
		'metabox_id' => 'wck_stp_custom_query_args_id',
		'metabox_title' => 'Custom Query Arguments',
		'post_type' => 'wck-swift-template',
		'meta_name' => 'wck_stp_custom_query_args',
		'meta_array' => $fint,
		'single'	=> true
	);

	if ( class_exists( 'Wordpress_Creation_Kit' ) ){
		new Wordpress_Creation_Kit( $args );
	}
}

add_filter("wck_stp_archive_query_args", "wck_stp_custom_archive_query_args", 20, 2);
function wck_stp_custom_archive_query_args( $args, $stp_id ){
	$custom_stp_args = get_cfc_meta( 'wck_stp_custom_query_args', $stp_id );

	
	$custom_args = json_decode($custom_stp_args[0]["query-arguments"], true);
	if ( is_array( $custom_args ) ){
		foreach( $custom_args as $argument => $value ){
			$args[$argument] = $value;
		}
	}
	return $args;
}
